_G.LockeSimulator = _G.LockeSimulator or {}

LockeSimulator.options_menu = "LockeSimulator_menu"
LockeSimulator.ModPath = ModPath
LockeSimulator.SaveFile = LockeSimulator.SaveFile or SavePath .. "LockeSimulator.txt"
LockeSimulator.ModOptions = LockeSimulator.ModPath .. "menus/modoptions.txt"
LockeSimulator.settings = {
	fov_camer = {cam_rot_x = 60, cam_rot_y = -60, cam_rot_z = 0, x = 0, y = 0, z = 100}
}

function LockeSimulator:Reset()
	self.settings = {
		fov_camer = {cam_rot_x = 60, cam_rot_y = -60, cam_rot_z = 0, x = 0, y = 0, z = 100}
	}
	self:Save()
end

function LockeSimulator:Load()
	local file = io.open(self.SaveFile, "r")
	if file then
		for key, value in pairs(json.decode(file:read("*all"))) do
			self.settings[key] = value
		end
		file:close()
	else
		self:Reset()
	end
end

function LockeSimulator:Save()
	local file = io.open(self.SaveFile, "w+")
	if file then
		file:write(json.encode(self.settings))
		file:close()
	end
	if Utils:IsInHeist() and LockeSimulator.CAMERA then
		local cam_rot_x, cam_rot_y, cam_rot_z, x, y, z = 0, -60, 60, 0, 0, 100
		if LockeSimulator and LockeSimulator.settings and LockeSimulator.settings.fov_camer then
			local fov_camer = LockeSimulator.settings.fov_camer
			cam_rot_x, cam_rot_y, cam_rot_z, x, y, z = fov_camer.cam_rot_x, fov_camer.cam_rot_y, fov_camer.cam_rot_z , fov_camer.x, fov_camer.y, fov_camer.z
		end
		local cam_rot = LockeSimulator.CAMERA._camera_object:rotation()
		if cam_rot then
			LockeSimulator.CAMERA._tp_camera_object:set_position(LockeSimulator.CAMERA._camera_object:position() + (cam_rot:x() * cam_rot_x) + (cam_rot:y() * cam_rot_y) + (cam_rot:z() * cam_rot_z) + Vector3(x, y, z))
			LockeSimulator.CAMERA._vp:set_camera(LockeSimulator.CAMERA._tp_camera_object)
		end
	end
end

LockeSimulator:Load()

Hooks:Add("LocalizationManagerPostInit", "LockeSimulator_loc", function(loc)
	LocalizationManager:add_localized_strings({
		["LockeSimulator_menu_title"] = "Locke Simulator",
		["LockeSimulator_menu_desc"] = "",
		["LockeSimulator_fov_camer_cam_rot_x_menu_title"] = "cam_rot_x",
		["LockeSimulator_fov_camer_cam_rot_y_menu_title"] = "cam_rot_y",
		["LockeSimulator_fov_camer_cam_rot_z_menu_title"] = "cam_rot_z",
		["LockeSimulator_fov_camer_x_menu_title"] = "x",
		["LockeSimulator_fov_camer_y_menu_title"] = "y",
		["LockeSimulator_fov_camer_z_menu_title"] = "z",
		["LockeSimulator_Reset_menu_title"] = "Reset",
	})
end)

function LockeSimulator:Warning()
	return
end

Hooks:Add("MenuManagerSetupCustomMenus", "LockeSimulatorOptions", function( menu_manager, nodes )
	MenuHelper:NewMenu( LockeSimulator.options_menu )
end)

Hooks:Add("MenuManagerPopulateCustomMenus", "LockeSimulatorOptions", function( menu_manager, nodes )
	MenuCallbackHandler.LockeSimulator_Reset_menu_callback = function(self, item)
		LockeSimulator:Reset()
	end
	MenuHelper:AddButton({
		id = "LockeSimulator_Reset_menu_callback",
		title = "LockeSimulator_Reset_menu_title",
		callback = "LockeSimulator_Reset_menu_callback",
		menu_id = LockeSimulator.options_menu,
	})
	MenuCallbackHandler.LockeSimulator_fov_camer_cam_rot_x_menu_callback = function(self, item)
		LockeSimulator.settings.fov_camer.cam_rot_x = math.floor(item:value())
		LockeSimulator:Save()
	end
	MenuHelper:AddSlider({
		id = "LockeSimulator_fov_camer_cam_rot_x_menu_callback",
		title = "LockeSimulator_fov_camer_cam_rot_x_menu_title",
		callback = "LockeSimulator_fov_camer_cam_rot_x_menu_callback",
		value =  LockeSimulator.settings.fov_camer.cam_rot_x,
		min = -200,
		max = 200,
		step = 1,
		show_value = true,
		menu_id = LockeSimulator.options_menu,
	})
	MenuCallbackHandler.LockeSimulator_fov_camer_cam_rot_y_menu_callback = function(self, item)
		LockeSimulator.settings.fov_camer.cam_rot_y = math.floor(item:value())
		LockeSimulator:Save()
	end
	MenuHelper:AddSlider({
		id = "LockeSimulator_fov_camer_cam_rot_y_menu_callback",
		title = "LockeSimulator_fov_camer_cam_rot_y_menu_title",
		callback = "LockeSimulator_fov_camer_cam_rot_y_menu_callback",
		value =  LockeSimulator.settings.fov_camer.cam_rot_y,
		min = -200,
		max = 200,
		step = 1,
		show_value = true,
		menu_id = LockeSimulator.options_menu,
	})
	MenuCallbackHandler.LockeSimulator_fov_camer_cam_rot_z_menu_callback = function(self, item)
		LockeSimulator.settings.fov_camer.cam_rot_z = math.floor(item:value())
		LockeSimulator:Save()
	end
	MenuHelper:AddSlider({
		id = "LockeSimulator_fov_camer_cam_rot_z_menu_callback",
		title = "LockeSimulator_fov_camer_cam_rot_z_menu_title",
		callback = "LockeSimulator_fov_camer_cam_rot_z_menu_callback",
		value =  LockeSimulator.settings.fov_camer.cam_rot_z,
		min = -200,
		max = 200,
		step = 1,
		show_value = true,
		menu_id = LockeSimulator.options_menu,
	})
	MenuCallbackHandler.LockeSimulator_fov_camer_x_menu_callback = function(self, item)
		LockeSimulator.settings.fov_camer.x = math.floor(item:value())
		LockeSimulator:Save()
	end
	MenuHelper:AddSlider({
		id = "LockeSimulator_fov_camer_x_menu_callback",
		title = "LockeSimulator_fov_camer_x_menu_title",
		callback = "LockeSimulator_fov_camer_x_menu_callback",
		value =  LockeSimulator.settings.fov_camer.x,
		min = -200,
		max = 200,
		step = 1,
		show_value = true,
		menu_id = LockeSimulator.options_menu,
	})
	MenuCallbackHandler.LockeSimulator_fov_camer_y_menu_callback = function(self, item)
		LockeSimulator.settings.fov_camer.y = math.floor(item:value())
		LockeSimulator:Save()
	end
	MenuHelper:AddSlider({
		id = "LockeSimulator_fov_camer_y_menu_callback",
		title = "LockeSimulator_fov_camer_y_menu_title",
		callback = "LockeSimulator_fov_camer_y_menu_callback",
		value =  LockeSimulator.settings.fov_camer.y,
		min = -200,
		max = 200,
		step = 1,
		show_value = true,
		menu_id = LockeSimulator.options_menu,
	})
	MenuCallbackHandler.LockeSimulator_fov_camer_z_menu_callback = function(self, item)
		LockeSimulator.settings.fov_camer.z = math.floor(item:value())
		LockeSimulator:Save()
	end
	MenuHelper:AddSlider({
		id = "LockeSimulator_fov_camer_z_menu_callback",
		title = "LockeSimulator_fov_camer_z_menu_title",
		callback = "LockeSimulator_fov_camer_z_menu_callback",
		value =  LockeSimulator.settings.fov_camer.z,
		min = -200,
		max = 200,
		step = 1,
		show_value = true,
		menu_id = LockeSimulator.options_menu,
	})
end)
Hooks:Add("MenuManagerBuildCustomMenus", "LockeSimulatorOptions", function(menu_manager, nodes)
	nodes[LockeSimulator.options_menu] = MenuHelper:BuildMenu( LockeSimulator.options_menu )
	MenuHelper:AddMenuItem(nodes["blt_options"], LockeSimulator.options_menu, "LockeSimulator_menu_title", "LockeSimulator_menu_desc")
end)

if ModCore then
	ModCore:new(LockeSimulator.ModPath .. "Config.xml", false, true):init_modules()
end